#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

float distLine(vec2 p, vec2 a, vec2 b) {
	vec2 ap = p - a;
    vec2 ab = b - a;
    float aDotB = clamp(dot(ap, ab) / dot(ab, ab), 0.0f, 1.0f);
    return length(ap - ab * aDotB);
}

float drawLine(vec2 uv, vec2 a, vec2 b) {
    float line = smoothstep(0.014f, 0.01f, distLine(uv, a, b));
    float dist = length(b-a);
    return (line * (smoothstep(1.3f, 0.8f, dist) * 0.5f + smoothstep(0.04f, 0.03f, fabs(dist - 0.75f))));
}

float n21(vec2 i) {
	float2 iptr2 = (vec2)(0.0f);
	i += fract(i * (vec2)(223.64f, 823.12f), &iptr2);
    i += dot(i, i + 23.14f);
	float iptr = 0.0f;
    return fract(i.x * i.y, &iptr);
}

vec2 n22(vec2 i) {
    float x = n21(i);
    return (vec2)(x, n21(i+x));
}

vec2 getPoint(vec2 id, vec2 offset, float iGlobalTime) {
	return offset + sin(n22(id + offset) * iGlobalTime) * 0.4f;
}

float layer(vec2 uv, float iGlobalTime) {
    float m = 0.0f;
    float t = iGlobalTime * 2.0f;
	
	vec2 iptr2 = (vec2)(0.0f);
    vec2 gv = fract(uv, &iptr2) - 0.5f;
    vec2 id = floor(uv) - 0.5f;
    
    vec2 p[9];
    int i = 0;
    for (int y = -1; y <= 1; y++) {
        for (int x = -1; x <= 1; x++) {
        	p[i++] = getPoint(id, (vec2)(x, y), iGlobalTime);
        }
    }
    
    for (int i = 0; i < 9; i++) {
    	m += drawLine(gv, p[4], p[i]);
        float sparkle = 1.0f / pow(length(gv - p[i]), 1.5f) * 0.005f;
		float iptr = 0.0f;
        m += sparkle * (sin(t + fract(p[i].x, &iptr) * 12.23f) * 0.4f + 0.6f);
    }
    
    m += drawLine(gv, p[1], p[3]);
    m += drawLine(gv, p[1], p[5]);
    m += drawLine(gv, p[7], p[3]);
    m += drawLine(gv, p[7], p[5]);
     
    return m;
}

vec4 screen(vec4 base, vec4 blend)
{
    vec4 white = (vec4)(1.0f);
    vec4 result = white - ((white - blend) * (white - base));
    return result;
}

__kernel void MAIN(
      __read_only image2d_t src_data,
      __write_only image2d_t dest_data,        //Data in global memory
      __global FilterParam* param,
	  int alpha)
{	
	int W = get_global_size(0);
	int H = get_global_size(1);
	
	int w = get_global_id(0);
	int h = get_global_id(1);
	vec2 resolution = (vec2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/resolution.xy;
	
	float iGlobalTime = param->cur_time;
	
	vec4 orig = INPUTSRC(src_data, param, tc);
	
	vec2 uv = tc - (vec2)(0.5f);
	uv.x *= resolution.x / resolution.y;
	
    vec3 vary = sin(iGlobalTime * 2.0f * (vec3)(.234f, .324f,.768f)) * 0.4f + 0.6f;
	
    vec4 retColor = (vec4)(0.0f);
    float fft = INPUTSRC(src_data, param, (vec2)(0.5f)).z;
    vary.x += (uv.x + 0.5f);
    retColor.xyz += pow(-uv.y + 0.5f, 5.0f) * fft * vary;
    
    float m = 0.0f;
    float x = sin(iGlobalTime * 0.1f);
    float y = cos(iGlobalTime * 0.2f);
    
    uv.x = dot(uv,(vec2)(x, -y));
	uv.y = dot(uv,(vec2)(y, x));
    
    for (int i = 0; i <= 4; i += 1) {
		float iptr = 0.0f;
		float z = fract((float)(i)/4.0f + iGlobalTime * 0.05, &iptr);
        float size = mix(15.0f, .1f, z) * 1.50f;
        float fade = smoothstep(0.0f, 1.0f, z) * smoothstep(1.0f, 0.9f, z);
        m += layer((size * uv) + (float)(i)/4.0f * 10.0f, iGlobalTime) * fade;
    }
    
    retColor.xyz += m * vary;
	retColor.xyz = clamp(retColor.xyz, 0.0f, 1.0f);
	retColor = screen(orig,retColor);
	retColor.w = orig.w;
	
    write_imagef(dest_data, gl_FragCoord, mix(orig, retColor, (float)(alpha)/100.0f));
}


    